/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.text.pagination;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.impactdev.impactor.api.services.Service;
import net.impactdev.impactor.core.text.pagination.ActivePagination;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Cache;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Caffeine;

public class PaginationService
implements Service {
    private final Cache<UUID, ActivePagination> active = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();

    @Override
    public String name() {
        return "Pagination Service";
    }

    public Optional<ActivePagination> pagination(UUID id) {
        return Optional.ofNullable(this.active.getIfPresent(id));
    }

    public void register(UUID uuid, ActivePagination pagination) {
        this.active.put(uuid, pagination);
    }
}

